package com.ejie.aa17a.utilidades;

import org.apache.poi.hssf.usermodel.HSSFCellStyle;

/**
 * Aa17aExcelUtil
 * 
 * @author UDA
 */
public class Aa17aExcelUtil {

	/**
	 * * Constructor Aa17aExcelUtil
	 * 
	 */
	private Aa17aExcelUtil() {
	}

	// BORDES DE TIPO ELEGIDO

	/**
	 * Pone los bordes izquierdo, superior e inferior de la celda de tipo
	 * elegido el resto sin bordes
	 * 
	 * @param style
	 *            HSSFCellStyle
	 * 
	 * @param tipo
	 *            short
	 * @return HSSFCellStyle
	 */
	public static HSSFCellStyle celdaBordeIzqSupInfTipo(HSSFCellStyle style, short tipo) {
		style.setBorderBottom(tipo);
		style.setBorderLeft(tipo);
		style.setBorderTop(tipo);
		return style;
	}

	/**
	 * Pone los bordes derecho, superior e inferior de la celda de tipo elegido
	 * el resto sin bordes
	 * 
	 * @param style
	 *            HSSFCellStyle
	 * @param tipo
	 *            short
	 * @return HSSFCellStyle
	 */
	public static HSSFCellStyle celdaBordeDchSupInfTipo(HSSFCellStyle style, short tipo) {
		style.setBorderBottom(tipo);
		style.setBorderRight(tipo);
		style.setBorderTop(tipo);
		return style;
	}

	/**
	 * Pone los bordes izquierdo, superior de la celda de tipo elegido el resto
	 * sin bordes
	 * 
	 * @param style
	 *            HSSFCellStyle
	 * @param tipo
	 *            short
	 * @return HSSFCellStyle
	 */
	public static HSSFCellStyle celdaBordeIzqSupTipo(HSSFCellStyle style, short tipo) {
		style.setBorderLeft(tipo);
		style.setBorderTop(tipo);
		return style;
	}

	/**
	 * Pone los bordes izquierdo, inferior de la celda de tipo elegido el resto
	 * sin bordes
	 * 
	 * @param style
	 *            HSSFCellStyle
	 * @param tipo
	 *            short
	 * @return HSSFCellStyle
	 */
	public static HSSFCellStyle celdaBordeIzqInfTipo(HSSFCellStyle style, short tipo) {
		style.setBorderBottom(tipo);
		style.setBorderLeft(tipo);
		return style;
	}

	/**
	 * Pone los bordes derecho, superior de la celda de tipo elegido el resto
	 * sin bordes
	 * 
	 * @param style
	 *            HSSFCellStyle
	 * @param tipo
	 *            short
	 * @return HSSFCellStyle
	 */
	public static HSSFCellStyle celdaBordeDchSupTipo(HSSFCellStyle style, short tipo) {
		style.setBorderRight(tipo);
		style.setBorderTop(tipo);
		return style;
	}

	/**
	 * Pone los bordes derecho, inferior de la celda de tipo elegido el resto
	 * sin bordes
	 * 
	 * @param style
	 *            HSSFCellStyle
	 * @param tipo
	 *            short
	 * @return HSSFCellStyle
	 */
	public static HSSFCellStyle celdaBordeDchInfTipo(HSSFCellStyle style, short tipo) {
		style.setBorderBottom(tipo);
		style.setBorderRight(tipo);
		return style;
	}

	/**
	 * Pone los bordes superior e inferior de la celda de tipo elegido el resto
	 * sin bordes
	 * 
	 * @param style
	 *            HSSFCellStyle
	 * @param tipo
	 *            short
	 * @return HSSFCellStyle
	 */
	public static HSSFCellStyle celdaBordeSupInfTipo(HSSFCellStyle style, short tipo) {
		style.setBorderBottom(tipo);
		style.setBorderTop(tipo);
		return style;
	}

	/**
	 * Pone los bordes derecho, izquierdo de la celda de tipo elegido el resto
	 * sin bordes
	 * 
	 * @param style
	 *            HSSFCellStyle
	 * @param tipo
	 *            short
	 * @return HSSFCellStyle
	 */
	public static HSSFCellStyle celdaBordeDchIzqTipo(HSSFCellStyle style, short tipo) {
		style.setBorderLeft(tipo);
		style.setBorderRight(tipo);
		return style;
	}

	/**
	 * Pone todos los bordes de la celda de tipo elegido
	 * 
	 * @param style
	 *            HSSFCellStyle
	 * @param tipo
	 *            short
	 * @return HSSFCellStyle
	 */
	public static HSSFCellStyle celdaBordesTipo(HSSFCellStyle style, short tipo) {
		style.setBorderBottom(tipo);
		style.setBorderLeft(tipo);
		style.setBorderRight(tipo);
		style.setBorderTop(tipo);
		return style;
	}

	// FIN BORDES TIPO ELEGIDO

	// BORDES MEZCLA TIPOS

	/**
	 * Pone en cada borde de la celda el tipo elegido
	 * 
	 * @param style
	 *            HSSFCellStyle
	 * @param bottom
	 *            short
	 * @param left
	 *            short
	 * @param right
	 *            short
	 * @param top
	 *            short
	 * @return HSSFCellStyle
	 */
	public static HSSFCellStyle celdaBordesTipos(HSSFCellStyle style, short bottom, short left, short right, short top) {
		style.setBorderBottom(bottom);
		style.setBorderLeft(left);
		style.setBorderRight(right);
		style.setBorderTop(top);
		return style;
	}

	// FIN BORDES MEZCLA TIPOS

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	// BORDES DE COLOR

	/**
	 * Pone los bordes izquierdo, superior e inferior de la celda de color el
	 * resto sin bordes
	 * 
	 * @param style
	 *            HSSFCellStyle
	 * @param color
	 *            short
	 * @return HSSFCellStyle
	 */
	public static HSSFCellStyle celdaBordeIzqSupInfColor(HSSFCellStyle style, short color) {
		style.setBottomBorderColor(color);
		style.setLeftBorderColor(color);
		style.setTopBorderColor(color);

		return style;
	}

	/**
	 * Pone los bordes derecho, superior e inferior de la celda de color el
	 * resto sin bordes
	 * 
	 * @param style
	 *            HSSFCellStyle
	 * @param color
	 *            short
	 * @return HSSFCellStyle
	 */
	public static HSSFCellStyle celdaBordeDchSupInfColor(HSSFCellStyle style, short color) {
		style.setBottomBorderColor(color);
		style.setRightBorderColor(color);
		style.setTopBorderColor(color);
		return style;
	}

	/**
	 * Pone los bordes izquierdo, superior de la celda de color el resto sin
	 * bordes
	 * 
	 * @param style
	 *            HSSFCellStyle
	 * @param color
	 *            short
	 * @return HSSFCellStyle
	 */
	public static HSSFCellStyle celdaBordeIzqSupColor(HSSFCellStyle style, short color) {
		style.setLeftBorderColor(color);
		style.setTopBorderColor(color);
		return style;
	}

	/**
	 * Pone los bordes izquierdo, inferior de la celda de color el resto sin
	 * bordes
	 * 
	 * @param style
	 *            HSSFCellStyle
	 * @param color
	 *            short
	 * @return HSSFCellStyle
	 */
	public static HSSFCellStyle celdaBordeIzqInfColor(HSSFCellStyle style, short color) {
		style.setBottomBorderColor(color);
		style.setLeftBorderColor(color);
		return style;
	}

	/**
	 * Pone los bordes derecho, superior de la celda de color el resto sin
	 * bordes
	 * 
	 * @param style
	 *            HSSFCellStyle
	 * @param color
	 *            short
	 * @return HSSFCellStyle
	 */
	public static HSSFCellStyle celdaBordeDchSupColor(HSSFCellStyle style, short color) {
		style.setRightBorderColor(color);
		style.setTopBorderColor(color);
		return style;
	}

	/**
	 * Pone los bordes derecho, inferior de la celda de color el resto sin
	 * bordes
	 * 
	 * @param style
	 *            HSSFCellStyle
	 * @param color
	 *            short
	 * @return HSSFCellStyle
	 */
	public static HSSFCellStyle celdaBordeDchInfColor(HSSFCellStyle style, short color) {
		style.setBottomBorderColor(color);
		style.setRightBorderColor(color);
		return style;
	}

	/**
	 * Pone los bordes superior e inferior de la celda de color el resto sin
	 * bordes
	 * 
	 * @param style
	 *            HSSFCellStyle
	 * @param color
	 *            short
	 * @return HSSFCellStyle
	 */
	public static HSSFCellStyle celdaBordeSupInfColor(HSSFCellStyle style, short color) {
		style.setBottomBorderColor(color);
		style.setTopBorderColor(color);
		return style;
	}

	/**
	 * Pone los bordes derecho, izquierdo de la celda de color el resto sin
	 * bordes
	 * 
	 * @param style
	 *            HSSFCellStyle
	 * @param color
	 *            short
	 * @return HSSFCellStyle
	 */
	public static HSSFCellStyle celdaBordeDchIzqColor(HSSFCellStyle style, short color) {
		style.setLeftBorderColor(color);
		style.setRightBorderColor(color);
		return style;
	}

	/**
	 * Pone todos los bordes de la celda de color
	 * 
	 * @param style
	 *            HSSFCellStyle
	 * @param color
	 *            short
	 * @return HSSFCellStyle
	 */
	public static HSSFCellStyle celdaBordesColor(HSSFCellStyle style, short color) {
		style.setBottomBorderColor(color);
		style.setLeftBorderColor(color);
		style.setRightBorderColor(color);
		style.setTopBorderColor(color);
		return style;
	}

	/**
	 * Pone cada borde de la celda de un color
	 * 
	 * @param style
	 *            HSSFCellStyle
	 * @param bottom
	 *            short
	 * @param left
	 *            short
	 * @param right
	 *            short
	 * @param top
	 *            short
	 * @return HSSFCellStyle
	 */
	public static HSSFCellStyle celdaBordesColores(HSSFCellStyle style, short bottom, short left, short right, short top) {
		style.setBottomBorderColor(bottom);
		style.setLeftBorderColor(left);
		style.setRightBorderColor(right);
		style.setTopBorderColor(top);
		return style;
	}
	// FIN BORDES COLOR

}
